/** @file   SpawnParameters.h
 * @brief   Definition of the spawn parameter literals.
 * @version $Revision: 1.6 $
 * @date    $Date: 2006/07/27 20:28:57 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_SPAWNPARAMETERS_H
#define H_WWW_SPAWNPARAMETERS_H


#define KParamNameTargetX       "targetX"
#define KParamNameTargetY       "targetY"
#define KParamNameIdCode        "idcode"
#define KParamNameAngle         "angle"
#define KParamNameFlags         "flags"
#define KParamNameRouteFile     "route"
#define KParamNameMainCategory  "mainCat"
#define KParamNameSubCategory   "subCat"
#define KParamNamePosX          "posX"
#define KParamNamePosY          "posY"
#define KParamNameOffsetX       "offsetX"
#define KParamNameOffsetY       "offsetY"
#define KParamNameUid           "uid"
#define KParamNameDelay         "delay"

#define KParamNameAnimMoveX     "animMoveX"
#define KParamNameAnimMoveY     "animMoveY"

#define KParamNameAiRange       "ai_range:"
#define KParamNameAttackRange   "attack_range:"

#define KParamNameParticleCount "particleCount"

#define KParamNameTeleportTlX   "teleTlX"
#define KParamNameTeleportTlY   "teleTlY"
#define KParamNameTeleportBrX   "teleBrX"
#define KParamNameTeleportBrY   "teleBrY"

#define KParamNameLightFenceNode1X        "node1x"
#define KParamNameLightFenceNode1Y        "node1y"
#define KParamNameLightFenceNode1OffsetX  "node1offx"
#define KParamNameLightFenceNode1OffsetY  "node1offy"
#define KParamNameLightFenceNode2X        "node2x"
#define KParamNameLightFenceNode2Y        "node2y"
#define KParamNameLightFenceNode2OffsetX  "node2offx"
#define KParamNameLightFenceNode2OffsetY  "node2offy"
#define KParamNameLightFenceSequence      "fenceseq"

#define KSpawnCategoryAliens      "<alien>"
#define KSpawnCategoryCivilians   "<civilian>"
#define KSpawnCategoryCars        "<car>"
#define KSpawnCategorySentryGuns  "<sentrygun>"
#define KSpawnCategoryFighters    "<fighter>"
#define KSpawnCategoryDecorative  "<decorative>"
#define KSpawnCategoryBarrels     "<barrel>"
#define KSpawnCategoryMachineGuns "<machinegun>"
#define KSpawnCategoryTank        "<tank>"
#define KSpawnCategoryCorpse      "<corpse>"
#define KSpawnCategoryStargate    "<stargate>"
#define KSpawnCategoryMines       "<mine>"
#define KSpawnCategoryNpcCharacter "<npc_character>"

#endif
